<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Section extends Model 
{

    protected $table = 'sections';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_type_id', 'group_id', 'name', 'order', 'is_visible');

    public function order_type()
    {
        return $this->belongsTo('OrderType');
    }

    public function questions()
    {
        return $this->hasMany('Question');
    }

    public function group()
    {
        return $this->belongsTo('Group');
    }

}